/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenarea.BlinkenSim;

import java.applet.Applet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Timer;
import java.util.TimerTask;
import org.blinkenarea.BlinkenLib.BlinkenFrame;
import org.blinkenarea.BlinkenLib.BlinkenMovie;
import org.blinkenarea.BlinkenSim.DataSource;
import org.blinkenarea.BlinkenSim.FrameReceiver;
import org.blinkenarea.BlinkenSim.MoviePlayerTimerTask;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MoviePlayer
extends DataSource {
    BlinkenMovie[] movies;
    int movieNo;
    int frameNo;
    FrameReceiver receiver;
    Timer timer;
    MoviePlayerTimerTask task;

    protected void setUp(Applet applet, String[] stringArray) {
        this.movies = new BlinkenMovie[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            try {
                URL uRL = applet.getDocumentBase();
                URL uRL2 = uRL != null ? new URL(uRL, stringArray[n]) : new URL("file:" + stringArray[n]);
                this.movies[n] = new BlinkenMovie(1, 1, 1, 1);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL2.openStream()));
                if (stringArray[n].toLowerCase().endsWith(".blm")) {
                    this.movies[n].loadBlm(bufferedReader);
                } else if (stringArray[n].toLowerCase().endsWith(".bmm")) {
                    this.movies[n].loadBmm(bufferedReader);
                } else if (stringArray[n].toLowerCase().endsWith(".bml")) {
                    this.movies[n].loadBml(bufferedReader);
                }
            }
            catch (MalformedURLException malformedURLException) {
                this.movies[n] = new BlinkenMovie(1, 1, 1, 1);
            }
            catch (IOException iOException) {
                this.movies[n] = new BlinkenMovie(1, 1, 1, 1);
            }
            ++n;
        }
        this.movieNo = 0;
        this.frameNo = 0;
    }

    public void start(FrameReceiver frameReceiver) {
        this.stop();
        this.movieNo = 0;
        this.frameNo = 0;
        this.receiver = frameReceiver;
        this.nextFrame();
    }

    public void stop() {
        this.receiver = null;
        this.timer = null;
        this.task = null;
    }

    public void nextFrame() {
        if (this.movies == null || this.movies.length <= 0 || this.receiver == null) {
            return;
        }
        if (this.movieNo >= this.movies.length) {
            this.movieNo = 0;
        }
        if (this.movies[this.movieNo] == null) {
            return;
        }
        BlinkenMovie blinkenMovie = this.movies[this.movieNo];
        if (this.frameNo >= blinkenMovie.getFrameCnt()) {
            this.frameNo = 0;
        }
        BlinkenFrame blinkenFrame = blinkenMovie.getFrame(this.frameNo);
        this.receiver.newFrame(blinkenFrame);
        this.timer = new Timer();
        this.task = new MoviePlayerTimerTask(this);
        this.timer.schedule((TimerTask)this.task, blinkenFrame.getDuration());
        ++this.frameNo;
        if (this.frameNo >= blinkenMovie.getFrameCnt()) {
            this.frameNo = 0;
            ++this.movieNo;
            if (this.movieNo >= this.movies.length) {
                ++this.movieNo;
            }
        }
    }

    private final /* synthetic */ void this() {
        this.movies = null;
        this.movieNo = 0;
        this.frameNo = 0;
        this.receiver = null;
        this.timer = null;
        this.task = null;
    }

    protected MoviePlayer() {
        this.this();
    }

    public MoviePlayer(Applet applet) {
        this.this();
        String string = applet.getParameter("movie");
        if (string == null || string.length() <= 0) {
            string = "movie.bml";
        }
        String[] stringArray = new String[]{string};
        this.setUp(applet, stringArray);
    }
}

